/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.network;

import io.github.fabricators_of_create.porting_lib.util.NetworkDirection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.C2SPacket;
import me.pepperbell.simplenetworking.S2CPacket;
import me.pepperbell.simplenetworking.SimpleChannel;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import slimeknights.mantle.network.packet.ISimplePacket;

public class NetworkWrapper {
    public final SimpleChannel network;
    private int id = 0;
    private static final String PROTOCOL_VERSION = Integer.toString(1);

    public NetworkWrapper(class_2960 channelName) {
        this.network = new SimpleChannel(channelName);
    }

    public <MSG extends ISimplePacket> void registerPacket(Class<MSG> clazz, Function<class_2540, MSG> decoder, @Nullable NetworkDirection direction) {
        this.registerPacket(clazz, ISimplePacket::encode, decoder, ISimplePacket::handle, direction);
    }

    public <MSG extends ISimplePacket> void registerPacket(Class<MSG> clazz, BiConsumer<MSG, class_2540> encoder, Function<class_2540, MSG> decoder, BiConsumer<MSG, Supplier<ISimplePacket.Context>> consumer, @Nullable NetworkDirection direction) {
        if (direction == NetworkDirection.PLAY_TO_CLIENT) {
            this.network.registerS2CPacket(clazz, this.id++, decoder);
        } else {
            this.network.registerC2SPacket(clazz, this.id++, decoder);
        }
    }

    public void sendToServer(ISimplePacket msg) {
        this.network.sendToServer((C2SPacket)msg);
    }

    public void sendVanillaPacket(class_2596<?> packet, class_1297 player) {
        if (player instanceof class_3222) {
            class_3222 sPlayer = (class_3222)player;
            sPlayer.field_13987.method_14364(packet);
        }
    }

    public void sendTo(S2CPacket msg, class_1657 player) {
        if (player instanceof class_3222) {
            this.network.sendToClient(msg, (class_3222)player);
        }
    }

    public void sendTo(ISimplePacket msg, class_3222 player) {
        this.network.sendToClient((S2CPacket)msg, player);
    }

    public void sendToClientsAround(ISimplePacket msg, class_3218 serverWorld, class_2338 position) {
        this.network.sendToClientsTracking((S2CPacket)msg, serverWorld, position);
    }

    public void sendToTrackingAndSelf(S2CPacket msg, class_1297 entity) {
        this.network.sendToClientsTrackingAndSelf(msg, entity);
    }

    public void sendToTracking(ISimplePacket msg, class_1297 entity) {
        this.network.sendToClientsTracking((S2CPacket)msg, entity);
    }
}

